/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.stal111.valhelsia_structures.block.DungeonDoorLeafBlock;
import com.stal111.valhelsia_structures.block.properties.DungeonDoorPart;
import com.stal111.valhelsia_structures.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.init.ModBlocks;
import com.stal111.valhelsia_structures.tileentity.DungeonDoorTileEntity;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class DungeonDoorBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<DungeonDoorPart> PART = ModBlockStateProperties.DUNGEON_DOOR_PART;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_OPEN = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);

    public DungeonDoorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)DungeonDoorPart.MIDDLE_1))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DungeonDoorTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(PART) == DungeonDoorPart.MIDDLE_1;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        VoxelShape shape;
        VoxelShape voxelShape = shape = (Boolean)state.func_177229_b((Property)OPEN) != false ? SHAPE_OPEN : SHAPE;
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && ((DungeonDoorPart)((Object)state.func_177229_b(PART))).isRight()) {
            shape = VoxelShapeHelper.add((double)-12.0, (double)0.0, (double)0.0, (double)-12.0, (double)0.0, (double)0.0, (VoxelShape[])new VoxelShape[]{shape});
        }
        return (Boolean)state.func_177229_b((Property)OPEN) != false && ((DungeonDoorPart)((Object)state.func_177229_b(PART))).isMiddle() ? VoxelShapes.func_197880_a() : VoxelShapeHelper.rotateShapeDirection((VoxelShape)shape, (Direction)((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        if (!this.canPlace(context)) {
            return null;
        }
        for (Position position : Position.values()) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.func_177981_b(i);
                if (position != Position.MIDDLE) {
                    pos1 = pos1.func_177972_a(Direction.func_176733_a((double)(context.func_195992_f().func_176734_d().func_185119_l() + position.getDirection().func_185119_l())));
                }
                if (context.func_195991_k().func_180495_p(pos1).func_196953_a(context)) continue;
                return null;
            }
        }
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidState.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            this.breakDoor(world, currentPos, state, null);
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        for (Position position : Position.values()) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.func_177981_b(i);
                if (position != Position.MIDDLE) {
                    pos1 = pos1.func_177972_a(Direction.func_176733_a((double)(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + position.getDirection().func_185119_l())));
                }
                if (pos1 == pos) continue;
                DungeonDoorPart part = DungeonDoorPart.valueOf((Object)((Object)position) + "_" + (i + 1));
                FluidState fluidstate = world.func_204610_c(pos1);
                boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
                world.func_180501_a(pos1, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)part))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        boolean open = (Boolean)state.func_177229_b((Property)OPEN) == false;
        HashMap<BlockPos, Object> map = new HashMap<BlockPos, Object>();
        boolean canOpen = true;
        if (!world.func_201670_d()) {
            for (Position position : Position.values()) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos offsetPos = this.getMainBlock(pos, state).func_177981_b(i);
                    if (position != Position.MIDDLE) {
                        offsetPos = offsetPos.func_177972_a(Direction.func_176733_a((double)(((Direction)state.func_177229_b((Property)FACING)).func_185119_l() + position.getDirection().func_185119_l())));
                        BlockPos leafPos = offsetPos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
                        if (open) {
                            if (!world.func_180495_p(leafPos).func_196953_a(new BlockItemUseContext(player, hand, new ItemStack((IItemProvider)ModBlocks.DUNGEON_DOOR.get()), hit))) {
                                canOpen = false;
                            }
                            map.put(leafPos, ((BlockState)((BlockState)((DungeonDoorLeafBlock)ModBlocks.DUNGEON_DOOR_LEAF.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, state.func_177229_b((Property)FACING))).func_206870_a((Property)ModBlockStateProperties.MIRRORED, (Comparable)Boolean.valueOf(position == Position.RIGHT))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_180495_p(leafPos).func_177230_c() == Blocks.field_150355_j)));
                        } else {
                            map.put(leafPos, (Boolean)world.func_180495_p(leafPos).func_177229_b((Property)WATERLOGGED) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                        }
                    }
                    map.put(offsetPos, world.func_180495_p(offsetPos).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)));
                }
            }
        }
        if (canOpen) {
            map.forEach((blockPos, blockState) -> world.func_180501_a(blockPos, blockState, blockState == Blocks.field_150350_a.func_176223_P() ? 35 : 10));
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        this.breakDoor((IWorld)world, pos, state, player);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos posDown = pos.func_177977_b();
        BlockState stateDown = world.func_180495_p(posDown);
        if (((DungeonDoorPart)((Object)state.func_177229_b(PART))).isBottom()) {
            return stateDown.func_224755_d((IBlockReader)world, posDown, Direction.UP);
        }
        if (((DungeonDoorPart)((Object)state.func_177229_b(PART))).func_176610_l().endsWith("3") && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            return false;
        }
        return stateDown.func_203425_a((Block)this);
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    private boolean canPlace(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (pos.func_177956_o() > context.func_195991_k().func_217301_I() - 4) {
            return false;
        }
        for (Position position : Position.values()) {
            BlockPos posDown = pos.func_177977_b();
            if (position != Position.MIDDLE) {
                posDown = posDown.func_177972_a(Direction.func_176733_a((double)(context.func_195992_f().func_176734_d().func_185119_l() + position.getDirection().func_185119_l())));
            }
            if (world.func_180495_p(posDown).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP)) continue;
            return false;
        }
        return true;
    }

    private void breakDoor(IWorld world, BlockPos pos, BlockState state, @Nullable PlayerEntity player) {
        BlockPos mainPos = this.getMainBlock(pos, state);
        if (world.func_201670_d() || player != null && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (Position position : Position.values()) {
            for (int k = 0; k < 4; ++k) {
                BlockState state1;
                BlockPos pos1 = mainPos.func_177981_b(k);
                if (position != Position.MIDDLE) {
                    BlockPos pos2;
                    BlockState state12;
                    pos1 = pos1.func_177972_a(Direction.func_176733_a((double)(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + position.getDirection().func_185119_l())));
                    if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && (state12 = world.func_180495_p(pos2 = pos1.func_177972_a(Direction.func_176733_a((double)((Direction)state.func_177229_b((Property)FACING)).func_185119_l())))).func_177230_c() == ModBlocks.DUNGEON_DOOR_LEAF.get()) {
                        world.func_217378_a(player, 2001, pos2, Block.func_196246_j((BlockState)state12));
                        world.func_180501_a(pos2, (Boolean)state12.func_177229_b((Property)WATERLOGGED) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 35);
                    }
                }
                if ((state1 = world.func_180495_p(pos1)).func_177230_c() != ModBlocks.DUNGEON_DOOR.get()) continue;
                world.func_217378_a(player, 2001, pos1, Block.func_196246_j((BlockState)state1));
                world.func_180501_a(pos1, (Boolean)state1.func_177229_b((Property)WATERLOGGED) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 35);
            }
        }
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    private BlockPos getMainBlock(BlockPos pos, BlockState state) {
        DungeonDoorPart part = (DungeonDoorPart)((Object)state.func_177229_b(PART));
        if (!part.isMiddle()) {
            pos = pos.func_177972_a(Direction.func_176733_a((double)(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + Position.getPositionFromPart(part).getDirection().func_185119_l())).func_176734_d());
        }
        return pos.func_177979_c(Integer.parseInt(String.valueOf(part.func_176610_l().charAt(part.func_176610_l().length() - 1))) - 1);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART, OPEN, WATERLOGGED});
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    private static enum Position {
        LEFT(Direction.WEST),
        MIDDLE(null),
        RIGHT(Direction.EAST);

        private final Direction direction;

        private Position(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public static Position getPositionFromPart(DungeonDoorPart part) {
            return part.isLeft() ? LEFT : (part.isRight() ? RIGHT : MIDDLE);
        }
    }
}

